function [Parnams,Parvals]=getExcelData(XLSname,SHTname,Direction)
% [Parnams,Parvals]=getExcelData(XLSname,SHTname,Direction)
% Get MODFLOW/MT3D/Seawat etc parameter names and parameter values stored
% in the Microfost Excel worksheet given by workbook name XLSname, and
% worksheet name SHTname.
% Direction is the direction in which the labels of the data are arranged.
%'V[ertical]' means that the parametrs names are arranged vertically
% with the values to the right of the parameter names so that multiple
% columns are possible.
% 'H[orizontal]' means the other way around, that is, the parameter names
% are arranged horizontally, with the variables themselves below the names,
% allowing multiple rows, such as for layers and streess periods.
%
% In vertical setup, lines with blank first cells, will be removed.
% This means that such lines are allowed on the sheet.
%
% TO 081231


% Copyright 2009 Theo Olsthoorn, TU-Delft and Waternet, without any warranty
% under free software foundation GNU license version 3 or later

if ismac
    warning('off','MATLAB:xlsread:Mode')
    try
    [Num,Txt]=xlsread(XLSname,SHTname,'');
    catch ME
        fprintf(['%s\n',...
            'xlsread can''t find the resquested information or sheet\n',...
            'sheet <<%s>> in file<<%s>>.\n',...
            'This may happen on the MAC or other non-PC operating systems lacking excel.com\n',...
            'so that xlsread must be run in basic mode.\n',...
            'However, xlsread in basic mode will only work properly if the xls worksheet\n',...
            'was saved as a <<Microsoft Excel 5.0/95 workbook>>.',...
            'Therefore, saving the your Excel file in this format is then a must and may solve this problem.'],...
            ME.message,SHTname,XLSname);
        rethrow(ME);
    end
    warning('on','MATLAB:xlsread:Mode')
else
    [Num,Txt]=xlsread(XLSname,SHTname);
end

if exist('Direction','var') && upper(Direction(1))=='V'
    I=ones(size(Txt(:,1)));
    for i=1:length(I)
        if isempty(Txt{i,1})
            I(i)=0;
        end
    end
    Parnams=Txt(I==1,2);  % parnams
    Parvals=Num(I==1,:);
else
    Row=1;
    if size(Txt,1)>1 && ~isempty(Txt{2,1})
        Row=2;
    end
    
    Parnams=Txt(Row,:);
    Num(all(isnan(Num),2),:)=[];  % remove lines that are all NaN which correspond to full text label lines
    Parvals=Num;
end
